 /*
 *     C/C++ Whetstone Benchmark Single or Double Precision
 *     
 *  #define Precision and Version not used
 *     
 *  Different compilers can produce different floating point numeric
 *  results, probably due to compiling instructions in a different
 *  sequence. As the program checks these, they may need to be changed.
 *  The log file indicates non-standard results and these values can
 *  be copied and pasted into this program. See // Values near the
 *  end of main(). These values are for optimised compiling and non-
 *  optimised results might be different.
 *
 *  Different compilers do not optimise the code in the same way.
 *  This can lead to wide variations in benchmark speeds. See results
 *  with MS6 compiler ID and compare with those from same CPUs from
 *  the Watcom compiler generated code.
 *
 *  calibrate changed as optimised out to give no numeric results.
 *  Removed from function calls, now global,
 */
 
 #include <math.h>       /* for sin, exp etc.           */
 #include <stdio.h>      /* standard I/O                */
 #include <conio.h>      /* for getch  - 2 occurrences  */ 
 #include <string.h>     /* for strcpy - 1 occurrence   */
 #include <stdlib.h>     /* for exit   - 1 occurrence   */
 #include <windows.h>
 #include <time.h>

// PRECISION
//    #define SPDP double
//    #define Precision "Double Precision SSE2"
//    #define SorD "2"
//    #define optX "4"

    #define SPDP float
    #define Precision "Single Precision SSE"
    #define SorD "1"
    #define optX "3"

// VERSION
#define options "Via Microsoft C/C++ Optimizing Compiler Version 18.00.21005.1 for x64" 

  void whetstones(int xtra, int x100);  
  void pa(SPDP e[4], SPDP t, SPDP t2);
  void po(SPDP e1[4], int j, int k, int l);
  void p3(SPDP *x, SPDP *y, SPDP *z, SPDP t, SPDP t1, SPDP t2);
  void pout(char title[22], float ops, int type, SPDP checknum,
                  SPDP time, int section);
  void printIt(SPDP val);
  
  static SPDP loop_time[9];
  static SPDP loop_mops[9];
  static SPDP loop_mflops[9];
  static SPDP TimeUsed;
  static SPDP mwips;
  static char  headings[9][18];
  static SPDP Check;
  static SPDP results[9];

  FILE    *outfile;
  char    timeday[30];
  char    configdata[4][200];

  double secs;
  LARGE_INTEGER starttime;
  int  calibrate = 1;
  int section;
 
void getDetails(void)
{
   printf (" Enter basic ID information for OS, CPU and Other\n\n");
   printf (" Operating System:   ");
   gets(configdata[0]);
   printf (" CPU  Details        ");
   gets(configdata[1]);
   printf (" Other Informations  ");
   gets(configdata[2]);
}

void local_time()
{
    time_t time_of_day;
    time_of_day = time( NULL ); 
    strcpy (timeday, ctime(&time_of_day)); // timeday = date and time
    return;
}

void start_time()
{
    QueryPerformanceCounter(&starttime);
}

void end_time()
{
    LARGE_INTEGER liDiff;
    LARGE_INTEGER liFreq;

    QueryPerformanceCounter(&liDiff);

    liDiff.QuadPart -= starttime.QuadPart;

    (void)QueryPerformanceFrequency(&liFreq);

    secs = (double)liDiff.QuadPart / (double) liFreq.QuadPart;
} 

 int main()
  {       
       int count = 10;
       int xtra=1;
       int endit;
       int i;
       int errors;
       int x100 = 100;
       int duration = 10;
       char expect[9][30];
       char was[30];

       printf("\n %s Whetstone Benchmark \n\n", Precision);
       printf(" %s\n\n", options);
         
       local_time();
       
       outfile = fopen("Whets.txt","a+");
       if (outfile == NULL)
       {
           printf (" Cannot open results file \n\n");
           printf(" Press any key\n");
           endit = getch();
           exit (0);
       }
    printf("\n ##########################################\n\n"); 
    getDetails();

    printf("\n ##########################################\n\n"); 
    fprintf(outfile, " ##########################################\n\n"); 

       fprintf (outfile, " Whetstone %s Benchmark %s\n",
                                          Precision, timeday);
       fprintf(outfile, " %s\n\n", options);

           printf("Calibrate\n");
           do
           {
                TimeUsed=0;
                
                whetstones(xtra,x100);
                
                printf("%11.5f Seconds %10.0lf   Passes (x 100)\n",
                                         TimeUsed,(SPDP)(xtra));
                calibrate = calibrate + 1;
                count = count - 1;
                if (TimeUsed > 0.2)
                   count = 0;
                else
                   xtra = xtra * 5;
           }
           while (count > 0);
           
           if (TimeUsed > 0)
                         xtra = (int)((SPDP)(duration * xtra) / TimeUsed);
           if (xtra < 1) xtra = 1;
           
           calibrate = 0;
      
           printf("\nUse %d  passes (x 100)\n", xtra);
    
           printf("\n %s Whetstone Benchmark \n\n", Precision);
           printf(" %s\n\n", options);
    
           printf("\nLoop content                  Result              MFLOPS "
                                    "     MOPS   Seconds\n\n");
    
           TimeUsed=0;
           whetstones(xtra,x100);
    
           printf("\nMWIPS            ");
           if (TimeUsed>0)
             mwips=(float)(xtra) * (float)(x100) / (10 * TimeUsed);
           else
             mwips = 0;
           
           printf("%39.3f%19.3f\n\n",mwips,TimeUsed);
         
           if (Check == 0)
              printf("Wrong answer  ");
                  
    
   //       Add results to output file Whets.txt

    fprintf(outfile, "Loop content                  Result              MFLOPS "
                                    "     MOPS   Seconds\n\n");
   
    for (section=1; section<9; section++)
    {
     fprintf (outfile, "%s  %24.17f   ", headings[section],
                                              results[section]);
     if (loop_mops[section] == 99999)
       {          
        fprintf (outfile,"  %9.3f           %9.3f\n",
                 loop_mflops[section], loop_time[section]);
       }
       else
       {       
        fprintf (outfile, "            %9.3f %9.3f\n",
             loop_mops[section], loop_time[section], results[section]);
       }
    }
 fprintf (outfile, "\nMWIPS             ");
 fprintf (outfile, "%39.3f%20.3f\n\n",mwips,TimeUsed);

 fflush(outfile);
   
    /*
        // Values Watcom
        
        if (strtol(SorD, NULL, 10) == 1)  // SP
        {
            sprintf(expect[1], "%24.17f", -1.12475025653839100);
            sprintf(expect[2], "%24.17f", -1.12274754047393800);
            sprintf(expect[3], "%24.17f",  1.00000000000000000);
            sprintf(expect[4], "%24.17f", 12.00000000000000000);
            sprintf(expect[5], "%24.17f",  0.49904659390449520);
            sprintf(expect[6], "%24.17f",  0.99999988079071040);
            sprintf(expect[7], "%24.17f",  3.00000000000000000);
            sprintf(expect[8], "%24.17f",  0.75110864639282230);
        }
        else // DP
        {
            sprintf(expect[1], "%24.17f", -1.12398255667391900);
            sprintf(expect[2], "%24.17f", -1.12187079889284400);
            sprintf(expect[3], "%24.17f",  1.00000000000000000);
            sprintf(expect[4], "%24.17f", 12.00000000000000000);
            sprintf(expect[5], "%24.17f",  0.49902937281515140);
            sprintf(expect[6], "%24.17f",  0.99999987890802820);
            sprintf(expect[7], "%24.17f",  3.00000000000000000);
            sprintf(expect[8], "%24.17f",  0.75100163018457870);
        }
    
        // Values MS Visual C++
        
        if (strtol(SorD, NULL, 10) == 1)  // SP
        {
            sprintf(expect[1], "%24.17f", -1.12441420555114750);
            sprintf(expect[2], "%24.17f", -1.12241148948669430);
            sprintf(expect[3], "%24.17f",  1.00000000000000000);
            sprintf(expect[4], "%24.17f", 12.00000000000000000);
            sprintf(expect[5], "%24.17f",  0.49907428026199341);
            sprintf(expect[6], "%24.17f",  0.99999988079071040);
            sprintf(expect[7], "%24.17f",  3.00000000000000000);
            sprintf(expect[8], "%24.17f",  0.75095528364181519);
        }
        else // DP
        {
            sprintf(expect[1], "%24.17f", -1.12398255667391100);
            sprintf(expect[2], "%24.17f", -1.12187079889295080);
            sprintf(expect[3], "%24.17f",  1.00000000000000000);
            sprintf(expect[4], "%24.17f", 12.00000000000000000);
            sprintf(expect[5], "%24.17f",  0.49902937281515491);
            sprintf(expect[6], "%24.17f",  0.99999987890802811);
            sprintf(expect[7], "%24.17f",  3.00000000000000000);
            sprintf(expect[8], "%24.17f",  0.75100163018453769);
        }
    
        // Values MS Visual C++ Toolkit 2003
        
        if (strtol(SorD, NULL, 10) == 1)  // SP
        {
            sprintf(expect[1], "%24.17f", -1.12457144260406490);
            if (strtol(optX, NULL, 10) == 3)
            sprintf(expect[1], "%24.17f", -1.12391686439514160);
            sprintf(expect[2], "%24.17f", -1.12256872653961180);
            if (strtol(optX, NULL, 10) == 3)
            sprintf(expect[2], "%24.17f", -1.12191414833068850);
            sprintf(expect[3], "%24.17f",  1.00000000000000000);
            sprintf(expect[4], "%24.17f", 12.00000000000000000);
            sprintf(expect[5], "%24.17f",  0.49904659390449524);
            sprintf(expect[6], "%24.17f",  0.99999988079071040);
            if (strtol(optX, NULL, 10) == 3)
            sprintf(expect[6], "%24.17f",  0.99999982118606567);            
            sprintf(expect[7], "%24.17f",  3.00000000000000000);
            sprintf(expect[8], "%24.17f",  0.75095528364181519);
        }
        else // DP
        {
            sprintf(expect[1], "%24.17f", -1.12398255667391100);
            sprintf(expect[2], "%24.17f", -1.12187079889295080);
            if (strtol(optX, NULL, 10) == 4)
            sprintf(expect[2], "%24.17f", -1.12187079889294510);
            sprintf(expect[3], "%24.17f",  1.00000000000000000);
            sprintf(expect[4], "%24.17f", 12.00000000000000000);
            sprintf(expect[5], "%24.17f",  0.49902937281515491);
            sprintf(expect[6], "%24.17f",  0.99999987890802811);
            sprintf(expect[7], "%24.17f",  3.00000000000000000);
            sprintf(expect[8], "%24.17f",  0.75100163018453769);
        }
     */
        if (strtol(SorD, NULL, 10) == 1)  // SP
        {
            sprintf(expect[1], "%24.17f", -1.12475013732910160);
            sprintf(expect[2], "%24.17f", -1.12274742126464840);
            sprintf(expect[3], "%24.17f",  1.00000000000000000);
            sprintf(expect[4], "%24.17f", 12.00000000000000000);
            sprintf(expect[5], "%24.17f",  0.49909302592277527);
            sprintf(expect[6], "%24.17f",  0.99999982118606567);
            sprintf(expect[7], "%24.17f",  3.00000000000000000);
            sprintf(expect[8], "%24.17f",  0.75110626220703125);
        }
  
        errors = 0;
        
        for (i=1; i<9; i++)
        {
            sprintf(was, "%24.17f", results[i]); 
    
            if (strcmp (expect[i], was)  != 0)
            {
                fprintf(outfile, " Test %d Non-standard result was %s instead of %s\n",
                                   i, was, expect[i]);  
                errors = errors + 1;
            }
        }
        if (errors == 0)
        {
            fprintf(outfile, " Numeric results were as expected\n");
        }
    
    fprintf(outfile, "\n ##########################################\n\n"); 
    fprintf(outfile, " Configuration Data Entered %s\n", timeday);   

    for (i=0; i<3; i++)
    {
        fprintf(outfile, " %s\n", configdata[i]);
    }
    fprintf(outfile,"\n End\n");

   fflush(outfile);
   fclose (outfile);
   printf("\n Press any key\n");
   endit = getch();
   return 0;
  }

    void whetstones(int xtra, int x100)
    {
        int n1,n2,n3,n4,n5,n6,n7,n8,i,ix,n1mult;
        SPDP x,y,z;              
        int j,k,l;
        SPDP e1[4];
        double timeb;
                        
        SPDP t =  (SPDP)0.49999975;
        SPDP t0 = t;        
        SPDP t1 = (SPDP)0.50000025;
        SPDP t2 = 2.0;
                
        Check=0.0;
       
        n1 = 12*x100;
        n2 = 14*x100;
        n3 = 345*x100;
        n4 = 210*x100;
        n5 = 32*x100;
        n6 = 899*x100;
        n7 = 616*x100;
        n8 = 93*x100;
        n1mult = 10;

        /* Section 1, Array elements */

        e1[0] = 1.0;
        e1[1] = -1.0;
        e1[2] = -1.0;
        e1[3] = -1.0;
        start_time();
        {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0; i<n1*n1mult; i++)
                  {
                      e1[0] = (e1[0] + e1[1] + e1[2] - e1[3]) * t;
                      e1[1] = (e1[0] + e1[1] - e1[2] + e1[3]) * t;
                      e1[2] = (e1[0] - e1[1] + e1[2] + e1[3]) * t;
                      e1[3] = (-e1[0] + e1[1] + e1[2] + e1[3]) * t;
                  }
                t = (SPDP)1.0 - t;
              }
            t =  t0;                    
        }
        end_time();
        timeb = secs/(double)(n1mult);
        pout("N1 floating point\0",(float)(n1*16)*(float)(xtra),
                             1,e1[3],(SPDP)timeb,1);

        /* Section 2, Array as parameter */

        start_time();
        {
            for (ix=0; ix<xtra; ix++)
              { 
                for(i=0; i<n2; i++)
                  {
                     pa(e1,t,t2);
                  }
                t = (SPDP)1.0 - t;
              }
            t =  t0;
        }
        end_time();
        timeb = secs;
        pout("N2 floating point\0",(float)(n2*96)*(float)(xtra),
                             1,e1[3],(SPDP)timeb,2);

        /* Section 3, Conditional jumps */
        j = 1;
        start_time();
         {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0; i<n3; i++)
                  {
                     if(j==1)       j = 2;
                     else           j = 3;
                     if(j>2)        j = 0;
                     else           j = 1;
                     if(j<1)        j = 1;
                     else           j = 0;
                  }
              }
         }
        end_time();
        timeb = secs;
        pout("N3 if then else  \0",(float)(n3*3)*(float)(xtra),
                        2,(SPDP)(j),(SPDP)timeb,3);

        /* Section 4, Integer arithmetic */
        j = 1;
        k = 2;
        l = 3;
        start_time();
        {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0; i<n4; i++)
                  {
                     j = j *(k-j)*(l-k);
                     k = l * k - (l-j) * k;
                     l = (l-k) * (k+j);
                     e1[l-2] = (SPDP)(j + k + l);
                     e1[k-2] = (SPDP)(j * k * l);
                  }
              }
        }
        end_time();
        timeb = secs;
        x = e1[0]+e1[1];
        pout("N4 fixed point   \0",(float)(n4*15)*(float)(xtra),
                                 2,x,(SPDP)timeb,4);
     
        /* Section 5, Trig functions */
        x = 0.5;
        y = 0.5;
        start_time();
        {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=1; i<n5; i++)
                  {
                     x = (SPDP)(t*atan(t2*sin(x)*cos(x)/(cos(x+y)+cos(x-y)-1.0)));
                     y = (SPDP)(t*atan(t2*sin(y)*cos(y)/(cos(x+y)+cos(x-y)-1.0)));
                  }
                t = (SPDP)1.0 - t;
              }
            t = t0;
        }
        end_time();
        timeb = secs;
        pout("N5 sin,cos etc.  \0",(float)(n5*26)*(float)(xtra),
                                 2,y,(SPDP)timeb,5);
  
        /* Section 6, Procedure calls */
        x = 1.0;
        y = 1.0;
        z = 1.0;
        start_time();
        {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0; i<n6; i++)
                  {
                     p3(&x,&y,&z,t,t1,t2);
                  }
              }
        }
        end_time();
        timeb = secs;
        pout("N6 floating point\0",(float)(n6*6)*(float)(xtra),
                                1,z,(SPDP)timeb,6);
  
        /* Section 7, Array refrences */
        j = 0;
        k = 1;
        l = 2;
        e1[0] = 1.0;
        e1[1] = 2.0;
        e1[2] = 3.0;
        start_time();
        {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0;i<n7;i++)
                  {
                     po(e1,j,k,l);
                  }
              }
        }
        end_time();
        timeb = secs;
        pout("N7 assignments   \0",(float)(n7*3)*(float)(xtra),
                            2,e1[2],(SPDP)timeb,7);
        
        /* Section 8, Standard functions */
        x = 0.75;
        start_time();
        {
            for (ix=0; ix<xtra; ix++)
              {
                for(i=0; i<n8; i++)
                  {
                     x = (SPDP)(sqrt(exp(log(x)/t1)));
                  }
              }
        }
        end_time();
        timeb = secs;
        pout("N8 exp,sqrt etc. \0",(float)(n8*4)*(float)(xtra),
                                2,x,(SPDP)timeb,8);

        return;
    }


    void pa(SPDP e[4], SPDP t, SPDP t2)
      {
         int j;
         for(j=0;j<6;j++)
            {
               e[0] = (e[0]+e[1]+e[2]-e[3])*t;
               e[1] = (e[0]+e[1]-e[2]+e[3])*t;
               e[2] = (e[0]-e[1]+e[2]+e[3])*t;
               e[3] = (-e[0]+e[1]+e[2]+e[3])/t2;
            }

         return;
      }

    void po(SPDP e1[4], int j, int k, int l)
      {
         e1[j] = e1[k];
         e1[k] = e1[l];
         e1[l] = e1[j];
         return;
      }

    void p3(SPDP *x, SPDP *y, SPDP *z, SPDP t, SPDP t1, SPDP t2)
      {
         *x = *y;
         *y = *z;
         *x = t * (*x + *y);
         *y = t1 * (*x + *y);
         *z = (*x + *y)/t2;
         return;
      }


    void pout(char title[18], float ops, int type, SPDP checknum,
              SPDP time, int section)
      {
        SPDP mops,mflops;

        Check = Check + checknum;
        loop_time[section] = time;
        strcpy (headings[section],title);
        TimeUsed =  TimeUsed + time;
        if (calibrate == 1)     
        {
              results[section] = checknum;
        }
        if (calibrate == 0)
          {              
            printf("%s %24.17f    ",headings[section],results[section]);    
       
            if (type == 1)
             {
                if (time>0)
                 {
                    mflops = ops/(1000000L*time);
                 }
                else
                 {
                   mflops = 0;
                 }
                loop_mops[section] = 99999;
                loop_mflops[section] = mflops;
                printf(" %9.3f          %9.3f\n",
                 loop_mflops[section], loop_time[section]);                
             }
            else
             {
                if (time>0)
                 {
                   mops = ops/(1000000L*time);
                 }
                else
                 {
                   mops = 0;
                 }
                loop_mops[section] = mops;
                loop_mflops[section] = 0;                 
                printf("           %9.3f%9.3f\n",
                 loop_mops[section], loop_time[section]);
             }
          }
          
        return;
      }


void printIt(SPDP val)
{
    if (val > 100)
    {
        fprintf (outfile, "%7.0f", val);
    }
    else if (val > 10)
    {
        fprintf (outfile, "%7.1f", val);
    }
    else if (val > 1)
    {
        fprintf (outfile, "%7.2f", val);
    }
    else
    {
        fprintf (outfile, "%7.3f", val);
    }
}
        

